import json
import re


def remove_comments_manual(code):
    result = []
    in_single_quote = False
    in_double_quote = False
    escape = False

    for line in code.split('\n'):
        new_line = []
        i = 0
        while i < len(line):
            c = line[i]
            if escape:
                new_line.append(c)
                escape = False
            elif c == '\\':
                new_line.append(c)
                escape = True
            elif in_single_quote:
                if c == "'" and not escape:
                    in_single_quote = False
                new_line.append(c)
            elif in_double_quote:
                if c == '"' and not escape:
                    in_double_quote = False
                new_line.append(c)
            else:
                if c == "'":
                    in_single_quote = True
                    new_line.append(c)
                elif c == '"':
                    in_double_quote = True
                    new_line.append(c)
                elif c == '#':
                    break
                else:
                    new_line.append(c)
            i += 1
        result.append(''.join(new_line))
    return '\n'.join(result)


import re
import json


def extract_triplets(text):
    pattern = re.compile(
        r'\{\s*"id"\s*:\s*(\d+)\s*,\s*'  
        r'"name"\s*:\s*"([^"]*?)"\s*,\s*' 
        r'"args"\s*:\s*(?:'
        r'(["\'])(.*?)\3' 
        r'|'
        r'(\{.*?\})' 
        r')\s*\}'  
        , re.DOTALL | re.MULTILINE
    )

    matches = pattern.findall(text)
    triplets = []
    for match in matches:
        id_, name, quote, args_str_quoted, args_str_braced = match
        if args_str_quoted:
            args_str = args_str_quoted
            try:
                args_str = args_str.encode('utf-8').decode('unicode_escape')
            except:
                args_str = args_str_quoted
        elif args_str_braced:
            args_str = args_str_braced
        else:
            args_str = ''

        try:
            args = json.loads(args_str)
        except:
            args = args_str
        triplets.append({
            'id': int(id_),
            'name': name,
            'args': args
        })

    return json.dumps(triplets)


if __name__ == "__main__":
    file_name = 'data/work_dirs/plan_Workflow_old_Llama3_1.json'
    with open(file_name, 'r') as fp:
        data = json.load(fp)

    for key, value in data.items():
        data[key]['prediction'] = remove_comments_manual(data[key]['prediction'])
        data[key]['prediction'] = extract_triplets(data[key]['prediction'])

    output_name = './plan_Workflow_old_refined_Llama3_1.json'
    with open(output_name, 'w') as fp:
        json.dump(data, fp)
